/***************************************************************************
 *
 * Copyright (c) 2013 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include <iostream>
#include <sstream>
#include <string>

#include "Log.h"

#include "Subdivision.h"
#include "TouchAreaSubdivision.h"

using namespace std;
using namespace LayerManagerCalibration;

bool TouchAreaSubdivision::validate()
{
    bool valid = true;

    // verify that a display offset x was defined
    if (!m_bDisplayOffsetXParsed)
    {
        LOG_WARNING("TouchAreaSubdivision", "No display offset x defined");
        valid = false;
    }

    // verify that a display offset y was defined
    if (!m_bDisplayOffsetYParsed)
    {
        LOG_WARNING("TouchAreaSubdivision", "No display offset y defined");
        valid = false;
    }

    return valid;
}

bool TouchAreaSubdivision::handleUnknownKey(const string& key, const string& value)
{
    if (key.compare("display offset x") == 0)
    {
        istringstream iss(value);
        iss >> m_u32DisplayOffsetX;

        if (iss.fail())
        {
            LOG_WARNING("TouchAreaSubdivision",
                        "Found invalid display offset x, value=" << value);
            return false;
        }
        else
        {
            LOG_INFO("TouchAreaSubdivision",
                     "Found display offset x=" << value);
        }

        m_bDisplayOffsetXParsed = true;
    }
    else if (key.compare("display offset y") == 0)
    {
        istringstream iss(value);
        iss >> m_u32DisplayOffsetY;

        if (iss.fail())
        {
            LOG_WARNING("TouchAreaSubdivision",
                        "Found invalid display offset y, value=" << value);
            return false;
        }
        else
        {
            LOG_INFO("TouchAreaSubdivision",
                     "Found display offset y=" << value);
        }

        m_bDisplayOffsetYParsed = true;
    }
    else
    {
        return false;
    }

    return true;
}
